﻿# -*- coding: utf-8 -*-
from Plugins.Plugin import PluginDescriptor
from Tools.Directories import fileExists
import os

import Plugins.Extensions.serienrecorder.SerienRecorder as SerienRecorder
import Plugins.Extensions.serienrecorder.SearchEvents as SearchEvents
import Plugins.Extensions.serienrecorder.SearchSerie as SearchSerie
import Plugins.Extensions.serienrecorder.SerienRecorderResource as SerienRecorderResource
import Plugins.Extensions.serienrecorder.WebChannels as SerienRecorderHelpers
import Plugins.Extensions.serienrecorder.WebChannels as WebChannels

serienRecMainPath = "/usr/lib/enigma2/python/Plugins/Extensions/serienrecorder/"

def main(session, **kwargs):
	for file_name in (('SerienRecorder', SerienRecorder), ('SearchEvents', SearchEvents), ('SearchSerie', SearchSerie), ('SerienRecorderResource', SerienRecorderResource), ('WebChannels', WebChannels), ('SerienRecorderHelpers', SerienRecorderHelpers)):
		if fileExists(os.path.join(serienRecMainPath, "%s.pyo" % file_name[0])):
			if (int(os.path.getmtime(os.path.join(serienRecMainPath, "%s.pyo" % file_name[0]))) < int(os.path.getmtime(os.path.join(serienRecMainPath, "%s.py" % file_name[0])))):
				reload(file_name[1])
		else:	
			reload(file_name[1])
		
	try:
		session.open(SerienRecorder.serienRecSetup, True)
	except:
		import traceback
		traceback.print_exc()

def Plugins(**kwargs):
	return [
		PluginDescriptor(name="SerienRecorder (Setup)", description="SerienRecorder Konfiguration", where = [PluginDescriptor.WHERE_PLUGINMENU], icon = "plugin.png", fnc=main),
		PluginDescriptor(name="SerienRecorder (Setup)", description="SerienRecorder Konfiguration", where = [PluginDescriptor.WHERE_EXTENSIONSMENU], fnc=main)
		]